\name{ber}
\alias{ber}
\title{
Batch Effects Removal
}
\description{
The function ber removes batch effects from (microarray) data. This function uses information about the batches and 
the expression levels in the data.
}
\usage{
ber(Y, b)
}
\arguments{
  \item{Y}{
A matrix with \eqn{n} rows and \eqn{g} columns, where \eqn{n} is the number of objects and \eqn{g} is the number of variables. 
In the case of gene expression data, columns correspond to genes and rows to samples.
}
  \item{b}{
A vector of class factor with the element in position \eqn{i} (\eqn{i=1,\ldots,n}) representing the batch
from which observation \eqn{i} belongs to.
}
}
\value{
A matrix of adjusted data with \eqn{n} rows and \eqn{g} columns.
}
\references{
M. Giordan (Submitted). An efficient two-stage procedure for removing batch
effects in high dimensional data experiments.
}
\author{
Marco Giordan, \email{giordan@stat.unipd.it}
}

\seealso{
\code{\link{berCov}}
}
\examples{
library(golubEsets)
library(vsn)
data(Golub_Merge)
E<-exprs(vsn2(Golub_Merge))
batch<-Golub_Merge$Source
Eadj<-ber(t(E),batch)
}
\keyword{model & regression}

