% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSpace.R
\name{removeSpace}
\alias{removeSpace}
\title{Remove white spaces from strings}
\usage{
removeSpace(x, begin = TRUE, end = TRUE, all = FALSE, ...)
}
\arguments{
\item{x}{Character string, can be a vector}

\item{begin}{Logical. Remove leading spaces at the beginning of the character string? DEFAULT: TRUE}

\item{end}{Logical. Remove trailing spaces at the end? DEFAULT: TRUE}

\item{all}{Logical. Remove all spaces anywhere in the string? DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{sub}} or \code{\link{gsub}}, like \code{ignore.case, perl, fixed, useBytes}.}
}
\value{
Character string (vector)
}
\description{
Remove leading and/or trailing white space from character strings
}
\note{
If all arguments are FALSE, the string is returned unchanged.\cr Not
extensively tested yet, please mail me any problems...
}
\examples{

s <- c("space at end     ", "  white at begin", "  both ", " special ^  ")
removeSpace(s)

# To add space, use:
x <- c("ab","abcde")
format(x)
format(x, justify="centre")
format(x, width=9)

}
\seealso{
\code{\link{sub}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2014
}
\keyword{character}
