% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal.R
\name{catPal}
\alias{catPal}
\title{Categorical color palette}
\usage{
catPal(n = 12, set = 1, alpha = 1)
}
\arguments{
\item{n}{Number of colors, max 12. DEFAULT: 12}

\item{set}{Integer for which set to use. Currently, only 1 is implemented.}

\item{alpha}{Transparency (0=transparent, 1=fully colored). DEFAULT: 1}
}
\value{
Character string vector with color names
}
\description{
Categorical color palette according to IwantHue as displayed on
\url{https://en.rockcontent.com/blog/subtleties-of-color-different-types-of-data-require-different-color-schemes}
}
\examples{
plot(rep(1,12), pch=16, cex=5, col=catPal(12), xaxt="n")
showPal()
plot(cumsum(rnorm(40)), type="l", col=catPal()[1], ylim=c(-10,10))
for(i in 2:6) lines(cumsum(rnorm(40)), col=catPal()[i])
}
\seealso{
\code{\link{showPal}}, \code{\link{seqPal}}, \code{\link{divPal}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Apr 2019
}
\keyword{color}
\keyword{dplot}
