% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openFile.R
\name{openFile}
\alias{openFile}
\title{open file in default application}
\usage{
openFile(file, ...)
}
\arguments{
\item{file}{Filename to be opened, as character string.}

\item{\dots}{Further arguments passed to \code{\link{system2}}}
}
\value{
Result of try(system2, ...), invisibly
}
\description{
open a file using \code{\link{system2}} with command based on operating system.
Tries to open the file with the program associated with its file extension.\cr
See \code{\link{openPDF}} to open files with sumatraPDF.
}
\examples{
\dontrun{ # excluded from CRAN checks, file opening not wanted
openFile("README.md")
openFile("Tests.R")
openFile(c("README.md","Tests.R"))
is.error(openFile("dummydummydoesntexist.R"), TRUE, TRUE)
openFile(tempdir())
}
#' # To open folders with system2:
# "nautilus" on linux ubuntu
# "open" or "dolphin" on mac
# "explorer" or "start" on windows

}
\references{
\url{https://askubuntu.com/questions/15354},
\url{https://apple.stackexchange.com/questions/212583}
}
\seealso{
\code{\link{openPDF}}, \code{\link{system2}}, \code{\link{checkFile}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2017
}
\keyword{file}
