% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-diff-beta-nb.R
\name{DiffBetaNB}
\alias{DiffBetaNB}
\title{Estimate Differences of Standardized Slopes
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
DiffBetaNB(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
differences of standardized regression slopes.}
\item{vcov}{Sampling variance-covariance matrix of
differences of standardized regression slopes.}
\item{est}{Vector of estimated
differences of standardized regression slopes.}
\item{fun}{Function used ("DiffBetaMC").}
}
}
\description{
Estimate Differences of Standardized Slopes
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of differences of standardized regression slopes
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of differences of standardized regression slopes,
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of sample covariances
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals
# for differences of standardized regression slopes
diff <- DiffBetaNB(nb)
# Methods --------------------------------------------------------
print(diff)
summary(diff)
coef(diff)
vcov(diff)
confint(diff, level = 0.95)
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{.CI}()},
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{diff}
