% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaSandwich-methods-r-sq-beta-sandwich.R
\name{print.rsqbetasandwich}
\alias{print.rsqbetasandwich}
\title{Print Method for an Object of Class \code{rsqbetasandwich}}
\usage{
\method{print}{rsqbetasandwich}(x, alpha = c(0.05, 0.01, 0.001), digits = 4, ...)
}
\arguments{
\item{x}{Object of class \code{rsqbetasandwich}.}

\item{alpha}{Significance level.}

\item{digits}{Digits to print.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of
multiple correlation coefficients
(R-squared and adjusted R-squared),
standard errors,
test statistics,
p-values,
and
confidence intervals.
}
\description{
Print Method for an Object of Class \code{rsqbetasandwich}
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
std <- BetaHC(object)
rsq <- RSqBetaSandwich(std)
print(rsq)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
