% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_icl.R
\name{em_icl}
\alias{em_icl}
\title{Integrated Complete-data Likelihood (ICL) Criterion}
\usage{
em_icl(llk, C, M, N, R, model_name = "K..", z)
}
\arguments{
\item{llk}{Log-likelihood value.}

\item{C}{Number of CpG sites.}

\item{M}{Number of methylation states identified in a DNA sample.}

\item{N}{Number of patients.}

\item{R}{Number of DNA samples collected from each patient.}

\item{model_name}{Fitted mixture model. Options are "K..", "KN." and/or "K.R" (default = "K..").}

\item{z}{A matrix of posterior probabilities of cluster membership, stored as z in the object from \code{\link[betaclust]{beta_k}}, \code{\link[betaclust]{beta_kn}} and \code{\link[betaclust]{beta_kr}} functions.}
}
\value{
The ICL value for the selected model.
}
\description{
Compute the ICL value for the optimal model.
}
\details{
Computes the ICL for a specified model given the log-likelihood, the dimension of the data, and the model names. This criterion penalises the BIC by including an entropy term favouring well separated clusters.
}
\seealso{
\code{\link{em_aic}}

\code{\link{em_bic}}
}
