% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{Beta.4p.fit}
\alias{Beta.4p.fit}
\title{Method of Moment Estimates of Shape- and Location Parameters of the Four-Parameter Beta Distribution.}
\usage{
Beta.4p.fit(scores)
}
\arguments{
\item{scores}{A vector of values to which the four-parameter beta distribution is to be fitted.}
}
\value{
A list of parameter-values required to produce a four-parameter beta distribution with the same first four moments as the observed distribution.
}
\description{
An implementation of the method of moments estimation of four-parameter beta distribution parameters presented by Hanson (1991). Given a vector of values, calculates the shape- and location parameters required to produce a four-parameter beta distribution with the same mean, variance, skewness and kurtosis (i.e., the first four moments) as the observed-score distribution.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100), freq = FALSE)

# To fit and retrieve the parameters for a four-parameter beta distribution
# to the observed-score distribution using Beta.4p.fit():
(params.4p <- Beta.4p.fit(testdata))
curve(dBeta.4P(x, params.4p$l, params.4p$u, params.4p$alpha, params.4p$beta), add = TRUE)
}
\references{
Hanson, Bradley A. (1991). Method of Moments Estimates for the Four-Parameter Beta Compound Binomial Model and the Calculation of Classification Consistency Indexes.American College Testing Research Report Series.

Lord, Frederic M. (1965). A Strong True-Score Theory, With Applications. Psychometrika, 30(3).
}
