% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{dBetaMS}
\alias{dBetaMS}
\title{Density Under a Specific Point of the Standard Beta PDD with Specific Mean and Variance or Standard Deviation.}
\usage{
dBetaMS(x, mean, variance = NULL, sd = NULL)
}
\arguments{
\item{x}{A specific point on the x-axis of the Standard Beta PDD.}

\item{mean}{The mean of the target Standard Beta probability density distribution.}

\item{variance}{The variance of the target Standard Beta probability density distribution.}

\item{sd}{The standard deviation of the target Standard Beta probability density distribution.}
}
\value{
A numeric value representing the required value for the beta Shape-parameter in order to produce a Standard Beta probability density distribution with the target mean and variance.
}
\description{
Calculates the density under specific points of the Standard Beta probability density distribution with defined mean and variance or standard deviation.
}
\examples{
# To compute the density at a specific point (e.g., 0.5) along the Standard
# (two-parameter) PDD with mean of 0.6 and variance of 0.04:
dBetaMS(x = 0.5, mean = 0.6, variance = 0.04)
}
