% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{R.ETL}
\alias{R.ETL}
\title{Model Implied Reliability from Livingston and Lewis' "Effective Test Length".}
\usage{
R.ETL(mean, variance, min = 0, max = 1, ETL)
}
\arguments{
\item{mean}{The mean of the observed-score distribution.}

\item{variance}{The variance of the observed-score distribution.}

\item{min}{The lower-bound (minimum possible value) of the observed-score distribution. Default is 0 (assuming observed scores represent proportions).}

\item{max}{The upper-bound (maximum possible value) of the observed-score distribution. Default is 1 (assuming observed scores represent proportions).}

\item{ETL}{The effective test length as defined by Livingston and Lewis (1995).}
}
\value{
An estimate of the reliability of a test, given the effective test length, mean, variance, and minimum and maximum possible scores of the observed-score distribution..
}
\description{
Calculate model-implied reliability given mean, variance, the minimum and maximum possible scores, and the effective test length.
}
\examples{
# Generate some fictional data. Say, 100 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
testdata <- rbinom(100, 100, rBeta.4P(100, .25, .75, 5, 3))
hist(testdata, xlim = c(0, 100))

# From the data-generating script above, the effective test length is 100.
# To estimate and retrieve the model-implied reliability using R.ETL():
R.ETL(mean = mean(testdata), variance = var(testdata), min = 0, max = 100,
ETL = 100)
}
\references{
Livingston, Samuel A. and Lewis, Charles. (1995). Estimating the Consistency and Accuracy of Classifications Based on Test Scores. Journal of Educational Measurement, 32(2).
}
