% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfast-package.R
\name{bfast-package}
\alias{bfast-package}
\title{Breaks For Additive Season and Trend (BFAST)}
\description{
BFAST integrates the decomposition of time series into trend, seasonal, and
remainder components with methods for detecting and characterizing abrupt
changes within the trend and seasonal components. BFAST can be used to
analyze different types of satellite image time series and can be applied to
other disciplines dealing with seasonal or non-seasonal time series,such as
hydrology, climatology, and econometrics. The algorithm can be extended to
label detected changes with information on the parameters of the fitted
piecewise linear models.

Additionally monitoring disturbances in BFAST-type models at the end of time
series (i.e., in near real-time) is available: Based on a model for stable
historical behaviour abnormal changes within newly acquired data can be
detected. Different models are available for modeling the stable historical
behavior. A season-trend model (with harmonic seasonal pattern) is used as a
default in the regresssion modelling.
}
\details{
The package contains:
\itemize{
\item \code{\link[=bfast]{bfast()}}: Main function for iterative decomposition and break detection as described in
Verbesselt et al (2010a,b).
\item \code{\link[=bfastlite]{bfastlite()}}: lightweight and fast detection of all breaks in a time series
using a single iteration with all components at once.
\item \code{\link[=bfastmonitor]{bfastmonitor()}}:
Monitoring approach for detecting disturbances in near real-time (see
Verbesselt et al. 2012).
\item \code{\link[=bfastpp]{bfastpp()}}: Data pre-processing for BFAST-type modeling.
\item Functions for plotting and printing, see \code{\link[=bfast]{bfast()}}.
\item \link{simts}: Artificial example data set.
\item \link{harvest}: NDVI time series of a P. radiata plantation
that is harvested.
\item \link{som}: NDVI time series of
locations in the south of Somalia to illustrate the near real-time
disturbance approach
}
}
\section{Package options}{
 bfast uses the following options to modify the
default behaviour:
\itemize{
\item \code{bfast.prefer_matrix_methods}:
logical value defining whether methods should try to
use the design matrix instead of the formula and a dataframe whenever
possible. This can avoid expensive repeated calls of \code{model.matrix} and
\code{model.frame} and make model fitting faster using \code{lm.fit}.
\item \code{bfast.use_bfastts_modifications}:
logical value defining whether a faster version of \code{\link[=bfastts]{bfastts()}} should be used.
\item \code{strucchange.use_armadillo}:
logical value defining whether to use C++ optimised code paths in strucchangeRcpp.
}

By default, all three are enabled.
See \code{\link[=set_fallback_options]{set_fallback_options()}} for a convenient interface for setting them all off
for debugging purposes.
}

\references{
\insertRef{janbfastmonitor}{bfast}

\insertRef{janbfast}{bfast}

\insertRef{janbfastpheno}{bfast}
}
\keyword{ts}
