% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnmbf01.R
\name{nnmbf01}
\alias{nnmbf01}
\title{Sample size determination for normal moment prior Bayes factor}
\usage{
nnmbf01(
  k,
  power,
  usd,
  null = 0,
  psd,
  dpm,
  dpsd,
  nrange = c(1, 10^5),
  lower.tail = TRUE,
  integer = TRUE,
  ...
)
}
\arguments{
\item{k}{Bayes factor threshold}

\item{power}{Target power}

\item{usd}{Unit standard deviation, the standard error of the parameter
estimate based on \eqn{\code{n}=1}{n=1}, see details}

\item{null}{Parameter value under the point null hypothesis. Defaults to
\code{0}}

\item{psd}{Spread of the normal moment prior assigned to the parameter under
the alternative in the analysis. The modes of the prior are located at
\eqn{\pm\sqrt{2}\,\code{psd}}{+-sqrt(2)*\code{psd}}}

\item{dpm}{Mean of the normal design prior assigned to the parameter}

\item{dpsd}{Standard deviation of the normal design prior assigned to the
parameter. Set to 0 to obtain a point prior at the design prior mean}

\item{nrange}{Sample size search range over which numerical search is
performed. Defaults to \code{c(1, 10^5)}}

\item{lower.tail}{Logical indicating whether Pr(BF \eqn{\leq} \code{k})
(\code{TRUE}) or Pr(BF \eqn{>} \code{k}) (\code{FALSE}) should be
computed. Defaults to \code{TRUE}}

\item{integer}{Logical indicating whether only integer valued sample sizes
should be returned. If \code{TRUE} the required sample size is rounded to
the next larger integer. Defaults to \code{TRUE}}

\item{...}{Other arguments passed to \code{stats::uniroot}}
}
\value{
The required sample size to achieve the specified power
}
\description{
This function computes the required sample size to obtain a
    normal moment prior Bayes factor (\link{nbf01}) more extreme than a
    threshold \code{k} with a specified target power.
}
\details{
It is assumed that the standard error of the future parameter
    estimate is of the form \eqn{\code{se} =\code{usd}/\sqrt{\code{n}}}{se =
    usd/sqrt(n)}. For example, for normally distributed data with known
    standard deviation \code{sd} and two equally sized groups of size
    \code{n}, the standard error of an estimated standardized mean difference
    is \eqn{\code{se} = \code{sd}\sqrt{2/n}}{se = sd*sqrt(2/n)}, so the
    corresponding unit standard deviation is \eqn{\code{usd} =
    \code{sd}\sqrt{2}}{usd = sd*sqrt(2)}. See the vignette for more
    information.
}
\examples{
nnmbf01(k = 1/10, power = 0.9, usd = 1, null = 0, psd = 0.5/sqrt(2), dpm = 0.5, dpsd = 0)
}
\seealso{
\link{nmbf01}, \link{pnmbf01}, \link{powernmbf01}
}
\author{
Samuel Pawel
}
