% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf01.R
\name{bf01}
\alias{bf01}
\title{z-test Bayes factor}
\usage{
bf01(estimate, se, null = 0, pm, psd, log = FALSE)
}
\arguments{
\item{estimate}{Parameter estimate}

\item{se}{Standard error of the parameter estimate}

\item{null}{Parameter value under the point null hypothesis. Defaults to
\code{0}}

\item{pm}{Mean of the normal prior assigned to the parameter under the
alternative}

\item{psd}{Standard deviation of the normal prior assigned to the parameter
under the alternative. Set to \code{0} to obtain a point prior at the
prior mean}

\item{log}{Logical indicating whether the natural logarithm of the Bayes
factor should be returned. Defaults to \code{FALSE}}
}
\value{
Bayes factor in favor of the null hypothesis over the alternative
    (\eqn{\text{BF}_{01}}{BF01} > 1 indicates evidence for the null
    hypothesis, whereas \eqn{\text{BF}_{01}}{BF01} < 1 indicates evidence for
    the alternative)
}
\description{
This function computes the Bayes factor that quantifies the
    evidence that the data (in the form of an asymptotically normally
    distributed parameter estimate with standard error) provide for a point
    null hypothesis with a normal prior assigned to the parameter under the
    alternative. The standard error is assumed to be known.
}
\examples{
bf01(estimate = 0.2, se = 0.05, null = 0, pm = 0, psd = 2)

}
\author{
Samuel Pawel
}
