% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflist.R
\name{reflist}
\alias{reflist}
\alias{reflist,lib_df-method}
\alias{reflist,character-method}
\title{Write a Reference List in rmarkdown}
\usage{
reflist(x, ...)

\S4method{reflist}{lib_df}(
  x,
  filename = "references",
  bib_file,
  delete_rmd = FALSE,
  delete_bib = delete_rmd,
  title = "Automatic Reference List",
  output = "html_document",
  nocite = "'@*'",
  urlcolor = "blue",
  encoding = "UTF-8",
  ...
)

\S4method{reflist}{character}(x, filename = "references", ...)
}
\arguments{
\item{x}{A \code{lib_df} object to produce the reference list. In the character
method, a character value indicating the path of a bibtex file
(passed to \code{\link[=read_bib]{read_bib()}}).}

\item{...}{Further arguments passed to \code{\link[=write_rmd]{write_rmd()}} by the lib_df method, or
to the lib_df method by the character method.}

\item{filename}{A character value with the name for the written Rmd file,
without file extension.}

\item{bib_file}{A character value with the name for the written bibtex file.
In the lib_df method it can be omitted and will then named by
\code{\link[=tempfile]{tempfile()}}. In the character method it is not required.}

\item{delete_rmd}{A logical value indicating whether written Rmd file should
be deleted after rendering html or not.}

\item{delete_bib}{A logical value indicating whether written bib file should
be deleted after rendering html or not.}

\item{title, output, nocite, urlcolor}{Arguments used for the yaml-header in
r-markdown and passed to \code{\link[=write_rmd]{write_rmd()}}. They can be cancelled using the
value NULL (not recommended for nocite).}

\item{encoding}{A character value indicating the encoding string. It is
passed to \code{\link[=write_bib]{write_bib()}}.}
}
\value{
An invisible object of class \code{rmd_doc}. A Rmd file will be written by
\code{\link[=write_rmd]{write_rmd()}} as well.
}
\description{
A fast way to produce a reference list in an r-markdown document from a
\code{lib_df} object.

This function may or may not produce intermediate files (bib and Rmd) and the
result can be assigned to an object for further edition
(see \code{\link[yamlme:update]{yamlme::update()}}).

A html file will be written by \code{\link[=write_rmd]{write_rmd()}} and \code{\link[=render_rmd]{render_rmd()}} in the
working directory and displayed by \code{\link[=browseURL]{browseURL()}}.
}
\examples{
\dontrun{
reflist(synopsis)
}

}
