% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematicEvolution.R
\name{thematicEvolution}
\alias{thematicEvolution}
\title{Create an Evolution Thematic Map}
\usage{
thematicEvolution(..., weighted = FALSE, labelsize = 0.5, size = 1)
}
\arguments{
\item{...}{is a sequence of names of thematic maps created by \code{\link{thematicMap}} function.}

\item{weighted}{is a logical. If FALSE, a thematic nexus is measures by the classical inclusion index (calculated using the 
number of keywords). If TRUE, the inclusion index is calculated considering the occurrences of keywords.}

\item{labelsize}{is numerical}

\item{size}{is numerical}
}
\value{
a list containing:
\tabular{lll}{
\code{nets}\tab   \tab The thematic nexus graph for each comparison\cr
\code{incMatrix}\tab   \tab Some useful statistics about the thematic nexus}
}
\description{
It creates an Evolution thematic map based on co-word network analysis and clustering.
The methodology is inspired by the proposal of Cobo et al. (2011).
}
\details{
\code{\link{thematicEvolution}} starts from two or more thematic maps created by \code{\link{thematicMap}} function.
}
\examples{

data(scientometrics)
years=c(2000)
list_df=timeslice(scientometrics, breaks = years)
M1=list_df[[1]]
M2=list_df[[2]]
NetMatrix1 <- biblioNetwork(M1, analysis = "co-occurrences", 
              network = "keywords", sep = ";")
S1 <- normalizeSimilarity(NetMatrix1, type = "association")
net1 <- networkPlot(NetMatrix1, normalize = "association",n = 50, 
     Title = "co-occurrence network",type="fruchterman",
     labelsize = 0.7, halo = FALSE, cluster = "walktrap",remove.isolates=FALSE,
     remove.multiple=FALSE, noloops=TRUE, weighted=TRUE)
res1 <- thematicMap(net1, NetMatrix1, S1, minfreq = 1)
#plot(res1$map)

NetMatrix2 <- biblioNetwork(M2, analysis = "co-occurrences", 
              network = "keywords", sep = ";")
S2 <- normalizeSimilarity(NetMatrix2, type = "association")
net2 <- networkPlot(NetMatrix2, normalize = "association",n = 50, 
     Title = "co-occurrence network",type="fruchterman",
     labelsize = 0.7, halo = FALSE, cluster = "walktrap",remove.isolates=FALSE,
     remove.multiple=FALSE, noloops=TRUE, weighted=TRUE)
res2 <- thematicMap(net2, NetMatrix2, S2, minfreq = 1)
#plot(res2$map)

nexus <- thematicEvolution(res1,res2,weighted=FALSE)

}
\seealso{
\code{\link{thematicMap}} function to create a thematic map based on co-word network analysis and clustering.

\code{\link{cocMatrix}} to compute a bibliographic bipartite network.

\code{\link{networkPlot}} to plot a bibliographic network.
}
