% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{predict.bife}
\alias{predict.bife}
\title{Predict method for \code{bife} fits}
\usage{
\method{predict}{bife}(object, type = c("link", "response"),
  X_new = NULL, alpha_new = NULL, corrected = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"bife"}.}

\item{type}{the type of prediction required. \code{"link"} is on the scale of the linear predictor
whereas \code{"response"} is on the scale of the response variable. Default is \code{"link"}.}

\item{X_new}{a regressor matrix for predictions. If not supplied predictions are based on the regressor
matrix returned by the object \code{\link{bife}}. See \code{Details}.}

\item{alpha_new}{a scalar or vector of fixed effects. If not supplied predictions are based on the
vector of fixed effects returned by \code{\link{bife}}. See \code{Details}.}

\item{corrected}{deprecated.}

\item{...}{other arguments}
}
\value{
The function \code{predict.bife} returns a vector of predictions.
}
\description{
\code{\link{predict.bife}} is a generic function which obtains predictions from an object 
returned by \code{\link{bife}}.
}
\details{
The model frame returned by the object \code{\link{bife}} only includes individuals that 
were not dropped before the fitting process (due to perfect classification). The linear 
predictors of perfectly classified observations are equal to \code{- Inf} or \code{Inf} whereas 
the predicted probabilities are equal to their response. In-sample predictions are only based on 
non-perfectly classified observations.

If \code{alpha_new} is supplied as a scalar the linear predictor is computed using the same 
value of the fixed effect for each observation. If \code{alpha_new} is supplied as a vector it 
has to be of same length as the rows of the corresponding regressor matrix.
}
\seealso{
\code{\link{bife}}
}
