% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.perc.bc.ci.R
\name{bfa.perc.bc.ci}
\alias{bfa.perc.bc.ci}
\title{Bias Correction Percentile Confidence Interval Function}
\usage{
bfa.perc.bc.ci(z, a1.ls, a1.ls.star, conf.level = 0.95)
}
\arguments{
\item{z}{a numeric vector containing the tree data.}

\item{a1.ls}{A numeric value of the least squares estimator of bifurcating autoregressive model}

\item{a1.ls.star}{A numeric vector representing B replicates of the least squares estimator}

\item{conf.level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
A numeric vector representing the lower and upper limits of the bias corrected percentile
confidence interval for the autoregressive coefficients of BAR model.
}
\description{
This function calculates the Bias-Corrected percentile CI for the least
squares estimator of the bifurcating autoregressive model.
}
\examples{
# Generating Non-contaminated normal BAR(1) tree and calculating the bias
# corrected percentile CI for the autoregressive coefficients of the BAR(1) model
z <- bfa.tree.gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
a1.ls <- bfa.ls(z,1)$coef[2]
a1.ls.star <- (rnorm(100,0.7,0.05))
bfa.perc.bc.ci(z, a1.ls, a1.ls.star, conf.level=0.95)
}
