% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.scatterplot.R
\name{bfa.scatterplot}
\alias{bfa.scatterplot}
\title{Scatterplots for Bifurcating Autoregressive Data}
\usage{
bfa.scatterplot(z, p, ...)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of the bifurcating autoregressive
model that is believed to best fit the data}

\item{...}{other graphical parameters that can be passed to \code{plot()} or
\code{pairs()} (see \code{\link[graphics]{par}} and
\code{\link[graphics]{pairs}})}
}
\value{
A single scatterplot when \code{p=1} or a matrix of scatterplots when
\code{p>1}.
}
\description{
Draw scatterplots between observations at time \code{t} and the lagged
observations from the given bifurcating autoregressive tree data.
}
\examples{
z <- bfa.tree.gen(63, 1, 1, 2, 0.5, 0.5, 0.2, 10, c(0.7))
bfa.scatterplot(z,1)
z<-bfa.tree.gen(63, 2, 1, 2, 0.5, 0.5, 0.2, 10, c(0.7,0.2))
bfa.scatterplot(z,2)
bfa.scatterplot(z,2,lower.panel=NULL)
}
