% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_main.R
\name{bdm.wtt}
\alias{bdm.wtt}
\title{Watertrack transform (WTT)}
\usage{
bdm.wtt(bdm, layer = 1)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{layer}{The number of the t-SNE layer (1 by default).}
}
\value{
A copy of the input \var{bdm} instance with \var{bdm$wtt} (WTT output). \code{bdm$wtt[[layer]]$layer = 'NC'} stands for not computed layers.
}
\description{
Starts the WTT algorithm (third setp of the mapping protocol).
}
\details{
This function requires the up-stream step \code{bdm.pakde()}.
}
\examples{

# --- load mapped dataset
bdm.example()
# --- perform WTT
exMap <- bdm.wtt(exMap)
# --- plot WTT output
bdm.plot(exMap)
}
