% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_reg.r
\name{bglm}
\alias{bglm}
\title{Function to carry out generalized linear regression on a data_frame data object}
\usage{
bglm(formula, family = gaussian_(), data, weights = NULL, offset = NULL,
  start = NULL, control = list(), etastart = NULL, mustart = NULL)
}
\arguments{
\item{formula}{formula that defines your regression model}

\item{family}{family object from activeReg, e.g. .gaussian(), .binomial(), .poisson(),
.quasipoisson(), .quasibinomial(), .Gamma(), .inverse.gaussian(),
.quasi()}

\item{data}{data_frame object containing data for linear regression}

\item{weights}{weights for the model}

\item{offset}{offsets for the model}

\item{start}{starting values for the linear predictor}

\item{control}{list of parameters for .control() function}

\item{etastart}{starting values for the linear predictor}

\item{mustart}{starting values for vector of means}
}
\description{
Function to carry out generalized linear regression on a data_frame data object
}
\examples{
require(parallel)
data("plasma", package = "bigReg")
plasma1 <- plasma
plasma1 <- data_frame(plasma1, 10, path = "outputs", nCores = 1)
plasma_glm <- bglm(ESR ~ fibrinogen + globulin, data = plasma1, family = binomial_("logit"))
summary(plasma_glm)
}

