% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.pgn.R
\name{read.pgn}
\alias{read.pgn}
\title{Reads PGN files into data frame}
\usage{
read.pgn(con, add.tags = NULL, n.moves = T, extract.moves = 10,
  last.move = T, stat.moves = T, big.mode = F, quiet = F,
  ignore.other.games = F, source.movetext = F)
}
\arguments{
\item{con}{connection argument passed directly to readLines() function. String - the name of the file which the data are to be read from or connection object or URL.}

\item{add.tags}{string vector containing additional tags to be parsed.
According to Seven Tag Roster rule:
http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm#c8.1.1
The STR tag pairs appear before any other tag pairs: "Event", "Site", "Date", "Round", "White", "Black" and "Result".
Using this argument you can specify supplemental tag names, such as: Player related information, Event related information, Opening information (locale specific), Opening information (third party vendors), Time and date related information, Time control, Alternative starting positions, Game conclusion and Miscellaneous.
Most popular: "WhiteElo", "BlackElo","ECO","SetUp" or "FEN". Case sensitive.}

\item{n.moves}{boolean (default TRUE), compute number of moves?}

\item{extract.moves}{integer (default 10) passed to extract_moves function. Additionaly value -1 will extract all moves from movetext (not recommended for big files). Value 0 means that moves will not be extracted.}

\item{last.move}{boolean (default TRUE) passed to extract_moves, ignored when extract.moves = 0}

\item{stat.moves}{boolean (default TRUE), compute moves count statistics? Could take a long time for big file.}

\item{big.mode}{boolean (default FALSE) used in read.pgn.ff function}

\item{quiet}{boolean (default FALSE), indicating if messages should appear.}

\item{ignore.other.games}{boolean (default FALSE) if TRUE result is subset of original dataset without games with result marked as "*", i.e. ongoing games}

\item{source.movetext}{boolean (default FALSE, experimental!) if TRUE column with original movetext will be added}
}
\value{
Data frame containg STR, additional tags (conditionally), Movetext, NMoves (conditionally), extracted moves (conditionally) with complete.movetext flag, figure moves count statistics (conditionally).
}
\description{
Reads PGN files into data frame
}
\examples{
f <- system.file("extdata", "2016_Candidates.pgn", package = "bigchess")
df <- read.pgn(f)
# ...successfully imported 56 games...
\donttest{
# Example downloaded from https://www.pgnmentor.com/files.html#players and gzipped:
f <- system.file("extdata", "Carlsen.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE)
# Fastest mode:
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,n.moves = FALSE,extract.moves = FALSE,
stat.moves = FALSE, ignore.other.games = FALSE)
# Parse additional tags and extract all moves:
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,add.tags = c("WhiteElo", "BlackElo", "ECO"),extract.moves = -1)
# Example of direct downloading data from chess.com using API:
df <- read.pgn("https://api.chess.com/pub/player/fabianocaruana/games/2013/03/pgn")
# Warning of incomplete line could appear}
\donttest{
# Example of scraping all of games given user:
user <- "fabianocaruana"
library("rjson")
json_file <- paste0("https://api.chess.com/pub/player/",user,"/games/archives")
json_data <- fromJSON(paste(readLines(json_file), collapse=""))
result <- data.frame()
for(i in json_data$archives)
result <- rbind(result,read.pgn(paste0(i,"/pgn")))}
}
