% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_move.R
\name{tree_move}
\alias{tree_move}
\title{Compute tree for a given move}
\usage{
tree_move(df, move)
}
\arguments{
\item{df}{data frame containg move and Result column from pgn function or data frame containing aggregated data from such df (containg columns: Result, W1, B1, W2, ..., WN, BN, Freq)}

\item{move}{character indicating which move should be browsed, example "W1"}
}
\value{
Data frame containg White_score (White winning percent), Draws_percent, Black_score and N (number of games). Sorted by power of move (White_score times N which describes popularity and score of move) descending.
}
\description{
Compute tree for a given move (frequencies and winning percent)
}
\examples{
f <- system.file("extdata", "Kasparov.gz", package = "bigchess")
con <- gzfile(f,encoding = "latin1")
df <- read.pgn(con,quiet = TRUE,stat.moves = FALSE)
# Analyze best answers to 1. e4 in Kasparov games (both white and black)
tree_move(subset(df,W1=="e4"),move = "B1")
# Analyze openings in aggregated data
tree_move(FirstTwoMoves,"W1")
}
