% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigdist_accessors.R
\name{bigdist_subset}
\alias{bigdist_subset}
\title{Subset parts of bigdist}
\usage{
bigdist_subset(x, index, file)
}
\arguments{
\item{x}{Object of class 'bigdist'}

\item{index}{Indexes of the bigdist to be subset as a bigdist}

\item{file}{(string) Name of the backing file to be created. Do not include
trailing ".bk". See details for the backup file format.}
}
\description{
Subset parts of bigdist
}
\details{
The filename format is of the form <somename>_<size>_<type>.bk where
  size is the number of observations and type is the data type like 'double',
  'float'.
}
\examples{
set.seed(1)
amat <- matrix(rnorm(1e3), ncol = 10)
td   <- tempdir()
temp <- bigdist(mat = amat, file = file.path(td, "temp_ex8"))
temp_subset <- bigdist_subset(temp, index = 21:30, file = file.path(td, "temp_ex9"))
temp_subset
temp_subset$fbm$backingfile
}
