% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conversions.r
\name{VPD.to.rH}
\alias{VPD.to.rH}
\alias{rH.to.VPD}
\alias{VPD.to.e}
\alias{e.to.VPD}
\alias{e.to.q}
\alias{q.to.e}
\alias{q.to.VPD}
\alias{VPD.to.q}
\title{Conversions between Humidity Measures}
\usage{
VPD.to.rH(VPD, Tair)

rH.to.VPD(rH, Tair)

VPD.to.e(VPD, Tair)

e.to.VPD(e, Tair)

e.to.q(e, pressure, constants = bigleaf.constants())

q.to.e(q, pressure, constants = bigleaf.constants())

q.to.VPD(q, Tair, pressure, constants = bigleaf.constants())

VPD.to.q(VPD, Tair, pressure, constants = bigleaf.constants())
}
\arguments{
\item{VPD}{Vapor pressure deficit (kPa)}

\item{Tair}{Air temperature (deg C)}

\item{rH}{Relative humidity (-)}

\item{e}{Vapor pressure (kPa)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{constants}{eps - ratio of the molecular weight of water vapor to dry air (-)}

\item{q}{Specific humidity (kg kg-1)}
}
\description{
Conversion between vapor pressure (e), vapor pressure deficit (VPD), 
             specific humidity (q), and relative humidity (rH).
}
\references{
Foken, T, 2008: Micrometeorology. Springer, Berlin, Germany.
}
