% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.r
\name{src_bigquery}
\alias{src_bigquery}
\title{A bigquery data source.}
\usage{
src_bigquery(project, dataset, billing = project)
}
\arguments{
\item{project}{project id or name}

\item{dataset}{dataset name}

\item{billing}{billing project, if different to \code{project}}
}
\description{
Use \code{src_bigquery} to connect to an existing bigquery dataset,
and \code{tbl} to connect to tables within that database.
}
\examples{
\dontrun{
library(dplyr)

# To run this example, replace billing with the id of one of your projects
# set up for billing
pd <- src_bigquery("publicdata", "samples", billing = "465736758727")
pd \%>\% tbl("shakespeare")

# With bigquery data, it's always a good idea to start by selecting
# only the variables you're interested in - this reduces the amount of
# data that needs to be scanned and hence decreases costs
natality <- pd \%>\%
  tbl("natality") \%>\%
  select(year:day, state, child_race, weight_pounds)
year_weights <- natality \%>\%
  group_by(year) \%>\%
  summarise(weight = mean(weight_pounds), n = n()) \%>\%
  collect()
plot(year_weights$year, year_weights$weight, type = "b")
}
}

