% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-field.R
\name{bq_field}
\alias{bq_field}
\alias{bq_fields}
\alias{as_bq_field}
\alias{as_bq_fields}
\title{BigQuery field (and fields) class}
\usage{
bq_field(name, type, mode = "NULLABLE", fields = list(), description = NULL)

bq_fields(x)

as_bq_field(x)

as_bq_fields(x)
}
\arguments{
\item{name}{The field name. The name must contain only letters (a-z, A-Z),
numbers (0-9), or underscores (_), and must start with a letter or
underscore. The maximum length is 300 characters.}

\item{type}{The field data type. Possible values include:
\code{"STRING"}, \code{"BYTES"}, \code{"INTEGER"}, \code{"FLOAT"}, \code{"BOOLEAN"}, \code{"TIMESTAMP"},
\code{"DATE"}, \code{"TIME"}, \code{"DATETIME"}, \code{"GEOGRAPHY"}, \code{"NUMERIC"},
\code{"BIGNUMERIC"}, \code{"JSON"}, \code{"RECORD"}.}

\item{mode}{The field mode. Possible values include: \code{"NULLABLE"},
\code{"REQUIRED"}, and \code{"REPEATED"}.}

\item{fields}{For a field of type "record", a list of sub-fields.}

\item{description}{The field description. The maximum length is 1,024
characters.}

\item{x}{A list of \code{bg_fields}}
}
\description{
\code{bq_field()} and \code{bq_fields()} create; \code{as_bq_field()} and \code{as_bq_fields()}
coerce from lists.
}
\examples{
bq_field("name", "string")

as_bq_fields(list(
  list(name = "name", type = "string"),
  bq_field("age", "integer")
))

# as_bq_fields() can also take a data frame
as_bq_fields(mtcars)
}
\seealso{
\code{bq_field()} corresponds to a \code{TableFieldSchema}, see
\url{https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#TableFieldSchema}
for more details.
}
