% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external-software.R
\name{snp_plinkQC}
\alias{snp_plinkQC}
\title{Quality Control}
\usage{
snp_plinkQC(prefix.in, plink.path = download_plink(), file.type = "--bfile",
  prefix.out = NULL, maf = 0.01, geno = 0.1, mind = 0.1, hwe = 1e-50,
  autosome.only = FALSE, extra.options = "")
}
\arguments{
\item{prefix.in}{Prefix (path without extension) of the dataset to be QCed.}

\item{plink.path}{Path to the executable of PLINK 1.9. Default downloads it.}

\item{file.type}{Type of the dataset to be QCed. Default is \code{"--bfile"} and
corresponds to bed/bim/fam files. You can also use \code{"--file"} for ped/map
files or \code{"--vcf"} for a VCF file. More information can be found at
\url{https://www.cog-genomics.org/plink/1.9/input}.}

\item{prefix.out}{Prefix (path without extension) of the bed/bim/fam dataset
to be created. Default is created by appending \code{"_QC"} to \code{prefix.in}.}

\item{maf}{Minimum Minor Allele Frequency (MAF) for a SNP to be kept.}

\item{geno}{Maximum proportion of missing values for a SNP to be kept.}

\item{mind}{Maximum proportion of missing values for a sample to be kept.}

\item{hwe}{Filters out all variants which have Hardy-Weinberg equilibrium
exact test p-value below the provided threshold.}

\item{autosome.only}{Whether to exclude all unplaced and non-autosomal
variants?}

\item{extra.options}{Other options to be passed to PLINK as a string. More
options can be found at \url{https://www.cog-genomics.org/plink2/filter}.}
}
\value{
The path of the newly created bedfile.
}
\description{
Quality Control (QC) and possible conversion to \emph{bed}/\emph{bim}/\emph{fam} files
using \href{https://www.cog-genomics.org/plink2}{PLINK 1.9}.
}
\examples{
bedfile <- system.file("extdata", "example.bed", package = "bigsnpr")
prefix  <- sub("\\\\.bed$", "", bedfile)
test <- snp_plinkQC(prefix.in = prefix,
                    prefix.out = tempfile(),
                    file.type = "--bfile",  # the default (for ".bed")
                    maf = 0.05,
                    geno = 0.05,
                    mind = 0.05,
                    hwe = 1e-10,
                    autosome.only = TRUE)
test

}
\references{
Purcell, Shaun, Benjamin Neale, Kathe Todd-Brown, Lori Thomas,
Manuel A R Ferreira, David Bender, Julian Maller, et al. 2007.
\emph{PLINK: a tool set for whole-genome association and population-based linkage
analyses.} American Journal of Human Genetics 81 (3). Elsevier: 559–75.
\url{http://dx.doi.org/10.1086/519795}.

Chang, Christopher C, Carson C Chow, Laurent CAM Tellier,
Shashaank Vattikuti, Shaun M Purcell, and James J Lee. 2015.
\emph{Second-generation PLINK: rising to the challenge of larger and richer
datasets.} GigaScience 4 (1): 7.
\url{http://dx.doi.org/10.1186/s13742-015-0047-8}.
}
\seealso{
\link{download_plink} \link{snp_plinkIBDQC}
}
