% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS.R
\name{same_ref}
\alias{same_ref}
\title{Determine reference divergence}
\usage{
same_ref(ref1, alt1, ref2, alt2)
}
\arguments{
\item{ref1}{The reference alleles of the first dataset.}

\item{alt1}{The alternative alleles of the first dataset.}

\item{ref2}{The reference alleles of the second dataset.}

\item{alt2}{The alternative alleles of the second dataset.}
}
\value{
A logical vector whether the references alleles are the same.
Missing values can result from missing values in the inputs or from
ambiguous strands.
}
\description{
Determine reference divergence while accounting for strand flips.
}
\examples{
same_ref(ref1 = c("A", "C", "T", "G", NA),
         alt1 = c("C", "T", "C", "A", "A"),
         ref2 = c("A", "C", "A", "A", "C"),
         alt2 = c("C", "G", "G", "G", "A"))
}
