% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biglasso.R
\name{COPY_biglasso_main}
\alias{COPY_biglasso_main}
\title{Sparse regression path}
\usage{
COPY_biglasso_main(X, y.train, ind.train, ind.col, covar.train,
  family = c("gaussian", "binomial"), alpha = 0.5, K = 10,
  ind.sets = sample(rep_len(1:K, n)), nlambda = 200, lambda.min = if (n >
  p) 1e-04 else 0.001, nlam.min = 50, n.abort = 10, eps = 1e-07,
  max.iter = 1000, dfmax = 20000, warn = FALSE, return.all = FALSE,
  ncores = 1)
}
\arguments{
\item{family}{Either "gaussian" (linear) or "binomial" (logistic).}

\item{alpha}{The elastic-net mixing parameter that controls the relative
contribution from the lasso (l1) and the ridge (l2) penalty. The penalty is
defined as \deqn{ \alpha||\beta||_1 + (1-\alpha)/2||\beta||_2^2.}
\code{alpha = 1} is the lasso penalty and \code{alpha} in between \code{0}
(\code{1e-6}) and \code{1} is the elastic-net penalty. Default is \code{0.5}.}

\item{K}{Number of sets used in the Cross-Model Selection and Averaging
(CMSA) procedure. Default is \code{10}.}

\item{ind.sets}{Integer vectors of values between \code{1} and \code{K} specifying
which set each index of the training set is in. Default randomly assigns
these values.}

\item{nlambda}{The number of lambda values. Default is \code{200}.}

\item{lambda.min}{The smallest value for lambda, \strong{as a fraction of
lambda.max}. Default is \code{.0001} if the number of observations is larger than
the number of variables and \code{.001} otherwise.}

\item{nlam.min}{Minimum number of lambda values to investigate. Default is \code{50}.}

\item{n.abort}{Number of lambda values for which prediction on the validation
set must decrease before stopping. Default is \code{10}.}

\item{eps}{Convergence threshold for inner coordinate descent.
The algorithm iterates until the maximum change in the objective after any
coefficient update is less than \code{eps} times the null deviance.
Default value is \code{1e-7}.}

\item{max.iter}{Maximum number of iterations. Default is \code{1000}.}

\item{dfmax}{Upper bound for the number of nonzero coefficients. Default is
\code{20e3} because, for large data sets, computational burden may be
heavy for models with a large number of nonzero coefficients.}

\item{warn}{Return warning messages for failures to converge and model
saturation? Default is \code{FALSE}.}

\item{return.all}{Whether to return coefficients for all lambda values.
Default is \code{FALSE} and returns only coefficients which maximize prediction
on the corresponding validation set.}
}
\description{
Fit solution paths for linear or logistic regression models penalized by
lasso (alpha = 1) or elastic-net (1e-6 < alpha < 1) over a grid of values
for the regularization parameter lambda.
}
\details{
The objective function for linear regression (\code{family = "gaussian"}) is
\deqn{\frac{1}{2n}\textrm{RSS} + \textrm{penalty},} for logistic regression
(\code{family = "binomial"}) it is \deqn{-\frac{1}{n} loglike +
\textrm{penalty}.}
}
\keyword{internal}
