% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossprodSelf.R
\name{big_cor}
\alias{big_cor}
\title{Correlation}
\usage{
big_cor(X, ind.row = rows_along(X), ind.col = cols_along(X),
  block.size = block_size(nrow(X)))
}
\arguments{
\item{X}{A \link[=FBM-class]{FBM}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}
}
\value{
A temporary \link[=FBM-class]{FBM}, with the following two attributes:
\itemize{
\item a numeric vector \code{center} of column scaling,
\item a numeric vector \code{scale} of column scaling.
}
}
\description{
Compute the correlation matrix of a Filebacked Big Matrix.
}
\section{Matrix parallelization}{

Large matrix computations (crossprods) are made block-wise and won't
be parallelized in order to not have to reduce the size of these blocks.
Instead, you may use \href{https://mran.microsoft.com/open/}{Microsoft R Open}
in order to accelerate these block matrix computations.
}

\examples{
X <- FBM(13, 17, init = rnorm(221))

# Comparing with cor
K <- big_cor(X)
class(K)
dim(K)
K$backingfile

true <- cor(X[])
all.equal(K[], true)

# Using only half of the data
n <- nrow(X)
ind <- sort(sample(n, n/2))
K2 <- big_cor(X, ind.row = ind)

true2 <- cor(X[ind, ])
all.equal(K2[], true2)
}
\seealso{
\link{cor} \link{big_crossprodSelf}
}
