% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcrossprodSelf.R
\docType{methods}
\name{big_tcrossprodSelf}
\alias{big_tcrossprodSelf}
\alias{tcrossprod,FBM,missing-method}
\title{Tcrossprod}
\usage{
big_tcrossprodSelf(X, fun.scaling = big_scale(center = FALSE, scale =
  FALSE), ind.row = rows_along(X), ind.col = cols_along(X),
  block.size = block_size(nrow(X)))

\S4method{tcrossprod}{FBM,missing}(x, y)
}
\arguments{
\item{X}{A \link[=FBM-class]{FBM}.}

\item{fun.scaling}{A function that returns a named list of
\code{mean} and \code{sd} for every column, to scale each of their elements
such as followed: \deqn{\frac{X_{i,j} - mean_j}{sd_j}.}
Default doesn't use any scaling.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}

\item{x}{A 'double' FBM.}

\item{y}{Missing.}
}
\value{
A temporary \link[=FBM-class]{FBM}, with the following two attributes:
\itemize{
\item a numeric vector \code{center} of column scaling,
\item a numeric vector \code{scale} of column scaling.
}
}
\description{
Compute \eqn{X.row X.row^T} for a Filebacked Big Matrix \code{X}
after applying a particular scaling to it.
}
\section{Matrix parallelization}{

Large matrix computations (crossprods) are made block-wise and won't
be parallelized in order to not have to reduce the size of these blocks.
Instead, you may use \href{https://mran.microsoft.com/open/}{Microsoft R Open}
in order to accelerate these block matrix computations.
}

\examples{
X <- FBM(13, 17, init = rnorm(221))
true <- tcrossprod(X[])

# No scaling
K1 <- tcrossprod(X)
class(K1)
stopifnot(all.equal(K1, true))

K2 <- big_tcrossprodSelf(X)
class(K2)
K2$backingfile
stopifnot(all.equal(K2[], true))

microbenchmark::microbenchmark(
  tcrossprod(X[]), tcrossprod(X), big_tcrossprodSelf(X)
)

# big_tcrossprodSelf() provides some scaling and subsetting
# Example using only half of the data:
n <- nrow(X)
ind <- sort(sample(n, n/2))
K3 <- big_tcrossprodSelf(X, fun.scaling = big_scale(), ind.row = ind)
true2 <- tcrossprod(scale(X[ind, ]))
stopifnot(all.equal(K3[], true2))
}
\seealso{
\link{tcrossprod}
}
