% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineBigMatrices.R
\name{combineBigMatrices}
\alias{combineBigMatrices}
\title{Combine, transpose big matrices and change colnames}
\usage{
combineBigMatrices(X, Z = NULL, file.out = "XZ.txt", transX = FALSE,
  transZ = FALSE, new.names = NULL, maxp = 1e+07, verbose = TRUE)
}
\arguments{
\item{X}{an object of class big.matrix.}

\item{Z}{an object of class big.matrix. Specify if you want to combine
matrices.}

\item{file.out}{a character string. The name of the output file.}

\item{transX}{a logical. If \code{TRUE}, the matrix \code{X} will be
transposed.}

\item{transZ}{a logical. If \code{TRUE}, the matrix \code{Z} will be
transposed.}

\item{new.names}{a vector of strings. Specify if you want to change names
of variables.}

\item{maxp}{a numeric. If \code{X} is big, it will be splitted into parts
with \code{maxp} elements. It will not change results, but it is
necessary if your computer does not have enough RAM. Set to a lower value
if you still have problems.}

\item{verbose}{a logical. Set \code{FALSE} if you do not want to see any
information during the selection procedure.}
}
\value{
A numeric, a number of variables successfully written.
}
\description{
Combine and/or transpose big matrices and write to a file with new
names of columns
}
\examples{
\dontrun{
library(bigmemory)
X <- matrix(sample(0:2, 20, replace=TRUE), 2, 10)
Z <- matrix(sample(0:2, 20, replace=TRUE), 2, 10)
write.table(X, "X.txt", col.names=FALSE, row.names=FALSE)
write.table(Z, "Z.txt", col.names=FALSE, row.names=FALSE)
X <- read.big.matrix("X.txt", sep=" ", type="char")
Z <- read.big.matrix("Z.txt", sep=" ", type="char")
# if it is possible, set type="char", reading will be quicker
names <- c("X1", "X2", "Z1", "Z2")
combineBigMatrices(X, Z, transX=TRUE, transZ=TRUE, new.names=names)
}

}

