% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigtcr_func.R
\name{get.gap.ccif}
\alias{get.gap.ccif}
\title{Conditional Bivariate Cumulative Incidence Function Estimation}
\usage{
get.gap.ccif(obs.y, event, v, tau = Inf)
}
\arguments{
\item{obs.y}{\eqn{Y}: time to failure events or censoring}

\item{event}{0: censored; \eqn{1, \ldots J}: type of failure events}

\item{v}{Time to the first failure event (e.g. disease recurrence)}

\item{tau}{Conditioning time \eqn{\tau} under which the CCIF is defined}
}
\value{
A matrix with class \code{gap.ccif} that has \eqn{J+2} columns. Column 1 and
2 are \eqn{(v,w)}. The rest columns correspond to \eqn{H_1(v,w)} to
\eqn{H_J(v,w)}. Each row represents a distinct observed time point and the
row name contains the value of this time point.
}
\description{
Estimate the conditional bivariate cumulative incidence function. See
\code{\link{bigtcr-package}}.
}
\examples{

Hj <- get.gap.ccif(obs.y=pancancer$obs.y, event=pancancer$min.type, v=pancancer$v, tau=120)

}

