% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-stats.R
\name{bike_summary_stats}
\alias{bike_summary_stats}
\title{Extract summary statistics of database}
\usage{
bike_summary_stats(bikedb)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database.
If no directory specified, it is presumed to be in \code{tempdir()}.}
}
\value{
A \code{data.frame} containing numbers of trips and stations along
with times and dates of first and last trips for each city in database and a
final column indicating whether the files match the latest published
versions.
}
\description{
Extract summary statistics of database
}
\examples{
\dontrun{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
# dl_bikedata (city = 'la', data_dir = data_dir) # or download some real data!
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
# create database indexes for quicker access:
index_bikedata_db (bikedb = bikedb)

bike_summary_stats ('testdb')

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files ('.', pattern = '.zip'))
}
}
