% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_MLBM_Binary_functions.R
\name{BinBlocICL_MLBM}
\alias{BinBlocICL_MLBM}
\title{BinBlocICL_MLBM function  for computation of the ICL criterion in the MLBM}
\usage{
BinBlocICL_MLBM(a,b,x,y,z1,v1,w1)
}
\arguments{
\item{a}{an hyperparameter for priors on the mixing proportions. By default, a=4.}

\item{b}{an hyperparameter for prior on the Bernoulli parameter. By default, b=1.}

\item{x}{binary matrix of observations (1rst matrix).}

\item{y}{binary matrix of observations (2nd matrix).}

\item{z1}{a numeric vector specifying the class of rows.}

\item{v1}{a numeric vector specifying the class of columns (1rst matrix).}

\item{w1}{a numeric vector specifying the class of columns (2nd matrix).}
}
\value{
a value of the ICL criterion.
}
\description{
Produce a plot object representing the resumed coclustered data-sets.
}
\examples{
require(bikm1)
set.seed(42)
n=200
J=120
K=120
g=2
h=2
l=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$alpha_gh=matrix(runif(4),ncol=h)
theta$beta_gl=matrix(runif(4),ncol=l)
data=BinBlocRnd_MLBM(n,J,K,theta)
res=BIKM1_MLBM_Binary(data$x,data$y,2,2,2,4,init_choice='smallVBayes')
BinBlocICL_MLBM(a=4,b=1,data$x,data$y, data$xrow,data$xcolx,data$xcoly)
}
