% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{PoissonBlocRnd}
\alias{PoissonBlocRnd}
\title{PoissonBlocRnd function for contingency data simulation}
\usage{
PoissonBlocRnd(J,K,theta)
}
\arguments{
\item{J}{a positive integer specifying the number of expected rows.}

\item{K}{a positive integer specifying the number of expected columns.}

\item{theta}{a list specifying the model parameters:

\code{rho_h}: a vector specifying the row mixing proportions.

\code{tau_l}: a vector specifying the column mixing proportions.

\code{gamma_hl}: a matrix specifying the distribution parameter.}
}
\value{
a list including the arguments:

\code{x}: simulated contingency data matrix.

\code{xrow}: numeric vector specifying row partition.

\code{xcol}: numeric vector specifying column partition.
}
\description{
Produce a simulated data matrix generated under the Poisson Latent Block Model.
}
\examples{
require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)

}
