% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIKM1_LBM_Binary-class.R
\docType{class}
\name{BIKM1_LBM_Binary-class}
\alias{BIKM1_LBM_Binary-class}
\title{Class "BIKM1_LBM_Binary"}
\description{
Class of object returned by the \code{\link{BIKM1_LBM_Binary}} function.
}
\section{Slots}{
 \describe{

\item{\code{model_max}: }{The selected model by the procedure with free energy W, theta, conditional probabilities (s_ig, r_jh), iter, empty_cluster, and the selected partitions z and v.}

\item{\code{criterion_choice}: }{A character string corresponding to the chosen criterion used for model selection, which can be "ICL" or "BIC".}

\item{\code{init_choice}: }{A character string corresponding to the chosen initialization strategy used for the procedure, which can be "random" or "Gibbs" or "smallVBayes".}

\item{\code{criterion_tab}: }{The matrix corresponding to the values of the chosen criterion for pairs of numbers of clusters visited by the BIKM1_LBM_Binary function. The matrix rows design the numbers of row clusters. If a pair is not visited, by default, the value is -Inf.}


\item{\code{W_tab}: }{The matrix corresponding to the values of the free energy (minimizer of the loglikelihood in the algorithm) for pairs of numbers of clusters visited by the procedure. The matrix rows design the numbers of row clusters. If a pair is not visited, by default, the value is -Inf.}


\item{\code{criterion_max}: }{Numeric indicating the maximum of the criterion values, calculated on the pairs of numbers of clusters visited by the BIKM1_LBM_Binary function.}


\item{\code{gopt}: }{An integer value indicating the number of row clusters selected by the BIKM1_LBM_Binary function.}


 \item{\code{hopt}: }{An integer value indicating the number of column clusters selected by the BIKM1_LBM_Binary function.}


}
}

\examples{

require(bikm1)
n=200
J=120
g=3
h=2
theta=list()
theta$pi_g=1/g *matrix(1,g,1)
theta$rho_h=1/h *matrix(1,h,1)
theta$alpha_gh=matrix(runif(6),ncol=h)
data=BinBlocRnd_LBM(n,J,theta)
res=BIKM1_LBM_Binary(data$x,3,3,a=4,init_choice='smallVBayes')
}
\keyword{class}
