% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_scatterplot}
\alias{bb_scatterplot}
\title{Helper for creating a scatter chart}
\usage{
bb_scatterplot(bb, data, mapping = NULL, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}}

\item{mapping}{Mapping of variables on the chart, see \code{\link{bbaes}}.}

\item{...}{unused}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a scatter chart
}
\note{
This function can be used with \code{\link{billboarderProxy}} in shiny application.
}
\examples{
# Use first and second variable by default
billboarder() \%>\% 
  bb_scatterplot(data = iris)


# Explicit mapping
billboarder() \%>\% 
  bb_scatterplot(
    data = iris, 
    mapping = bbaes(Petal.Length, Petal.Width)
  ) \%>\% 
  bb_x_axis(tick = list(fit = FALSE))


# Grouping variable
billboarder() \%>\% 
  bb_scatterplot(
    data = iris, 
    mapping = bbaes(Sepal.Length, Sepal.Width, group = Species)
  )
  
# Size variable
billboarder() \%>\% 
  bb_scatterplot(
    data = iris, 
    mapping = bbaes(Sepal.Length, Sepal.Width,
                    group = Species, size = Petal.Width),
    range = c(0.5, 120)
  ) \%>\% 
  bb_x_axis(tick = list(fit = FALSE))

}
