% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designFunctions.R
\name{designPower}
\alias{designPower}
\title{Number of groups or group size needed to achieve a power level in 
one parameter group testing}
\usage{
designPower(
  n,
  s,
  fixed = "s",
  delta,
  p.hyp,
  conf.level = 0.95,
  power = 0.8,
  alternative = "two.sided",
  method = "CP",
  biasrest = 0.05
)
}
\arguments{
\item{n}{integer specifying the maximum number of groups \kbd{n} allowed 
when \kbd{fixed="s"} or the fixed number of groups when \kbd{fixed="n"}. 
When \kbd{fixed="s"}, a vector of two integers giving the range of \kbd{n} 
which power shall be iterated over is also allowed.}

\item{s}{integer specifying the fixed group size (number of units per group) 
when \kbd{fixed="s"} or the maximum group size allowed in the planning of 
the design when \kbd{fixed="n"}.}

\item{fixed}{character string specifying whether the number of groups 
\kbd{"n"} or the group size \kbd{"s"} is to be held at a fixed value.}

\item{delta}{the absolute difference between the true proportion and the 
hypothesized proportion which shall be detectable with the specified power.}

\item{p.hyp}{the proportion in the hypotheses, specified as a value between 
0 and 1.}

\item{conf.level}{confidence level of the decision. The default 
confidence level is 0.95.}

\item{power}{level of power to be achieved, specified as a 
probability between 0 and 1.}

\item{alternative}{character string defining the alternative hypothesis, 
either \kbd{"two.sided"}, \kbd{"less"}, or \kbd{"greater"}.}

\item{method}{character string specifying the confidence interval method 
(see \code{\link{propCI}}) to be used.}

\item{biasrest}{a value between 0 and 1, specifying the absolute bias
maximally allowed for a point estimate.}
}
\value{
A list containing:
\item{nout}{the number of groups necessary to reach the power with the 
specified parameters, when \kbd{fixed="s"} only.}
\item{sout}{the group size necessary to meet the conditions, when 
\kbd{fixed="n"} only.}
\item{powerout}{the power for the specified parameters and the selected 
number of groups \kbd{n} when \kbd{fixed="s"} or the selected group 
size \kbd{s} when \kbd{fixed="n"}.}
\item{biasout}{the bias for the specified parameters and the selected 
number of groups \kbd{n} when \kbd{fixed="s"} or the selected group 
size \kbd{s} when \kbd{fixed="n"}.}
\item{power.reached}{a logical value indicating whether the 
specified level of power was reached.}
\item{bias.reached}{a logical value indicating whether the maximum 
allowed bias was reached.}
\item{nit}{the number of groups for each iteration.}
\item{sit}{the group size for each iteration.}
\item{powerit}{the power achieved for each iteration.}
\item{biasit}{the bias for each iteration.}
\item{maxit}{the iteration at which the maximum power was reached, 
or the total number of iterations.}
\item{alternative}{the alternative hypothesis specified by the user.}
\item{p.hyp}{the hypothesized proportion specified by the user.}
\item{delta}{the absolute difference between the true proportion and the 
hypothesized proportion specified by the user.}
\item{power}{the desired power specified by the user.}
\item{biasrest}{the maximum absolute bias specified by the user.}
}
\description{
For a fixed number of groups (group size), determine the 
group size (number of groups) needed to obtain a specified power level to 
reject a hypothesis for a proportion in one parameter group testing.
}
\details{
The power of a hypothesis test performed by a confidence interval 
is defined as the probability that a confidence interval excludes the 
thresholdparameter (\kbd{p.hyp}) of the hypothesis.

When \kbd{fixed="s"}, this function increases the number of groups until a 
pre-specified level of power is reached or the maximum number of groups 
\kbd{n} is reached. Since the power does not increase monotonely with 
increasing \kbd{n} for single proportions but oscillates between local 
maxima and minima, the simple iteration given here will generally result in 
selecting \kbd{n} for which the given confidence interval method shows a 
local minimum of coverage if the null hypothesis is true. Bias decreases 
monotonely with increasing the number of groups (if other parameters are 
fixed). The resulting problems of choosing a number of groups which results 
in satisfactory power are solved in the following manner:

In the case that the pre-specified power is reached within the given 
range of \kbd{n}, the smallest \kbd{n} is returned for which at least 
this power is reached, as well as the actual power for this \kbd{n}.

In the case that the pre-specified power is not reached within the given 
value, that \kbd{n} is returned for which maximum power is achieved, and 
the corresponding value of power.

In the case that the bias restriction is violated even for the largest 
\kbd{n} within the given range of \kbd{n}, simply that \kbd{n} will be 
returned for which power was largest in the given range.

Especially for large \kbd{n}, the calculation time may become large 
(particularly for the Blaker interval). Alternatively, the function 
\code{\link{gtPower}} might be used instead to calculate power and bias 
only for some particular combinations of the input arguments.

When \kbd{fixed="n"}, this function increases the size of groups until a 
pre-specified level of power is reached. Since the power does not increase 
monotonely with increasing \kbd{s} for single proportions but oscillates 
between local maxima and minima, the simple iteration given here will 
generally result in selecting \kbd{s} for which the given confidence 
interval method shows a local minimum of coverage if the null hypothesis 
is true. Since the positive bias of the estimator in group testing 
increases with increasing group size, this function checks whether the bias 
is smaller than a pre-specified level (\kbd{bias.rest}). If the bias violates 
this restriction for a given combination \kbd{n}, \kbd{s}, and \kbd{delta}, 
\kbd{s} will not be further increased and the actual power of the last 
acceptable group size \kbd{s} is returned.
}
\examples{
# Assume the objective is to show that a proportion is 
#   smaller than 0.005 (i.e. 0.5 percent) with a power 
#   of 0.80 (i.e. 80 percent) if the unknown proportion
#   in the population is 0.003 (i.e. 0.3 percent);
#   thus, a delta of 0.002 shall be detected.
# A 95\% Clopper Pearson CI shall be used. 
# The maximum group size because of limited
#   sensitivity of the diagnostic test might be s=20 and we
#   can only afford to perform maximally 100 tests:
designPower(n=100, s=20, delta=0.002, p.hyp=0.005, fixed="s",
             alternative="less", method="CP", power=0.8)
        
# One might accept to detect delta=0.004,
#   i.e. reject H0: p>=0.005 with power 80 percent 
#   when the true proportion is 0.001:
designPower(n=100, s=20, delta=0.004, p.hyp=0.005, fixed="s",
             alternative="less", method="CP", power=0.8)
             
# Power for a design with a fixed group size of s=1 
#   (individual testing).
designPower(n=500, s=1, delta=0.05, p.hyp=0.10, 
            fixed="s", method="CP", power=0.80)
        
# Assume that objective is to show that a proportion
#   is smaller than 0.005 (i.e. 0.5\%) with a 
#   power of 0.80 (i.e. 80\%) if the unknown proportion
#   in the population is 0.003 (i.e. 0.3\%); thus, a 
#   delta = 0.002 shall be detected. 
# A 95\% Clopper-Pearson CI shall be used. 
# The maximum number of groups might be 30, where the 
#   overall sensitivity is not limited until group 
#   size s=100.
designPower(s=100, n=30, delta=0.002, p.hyp=0.005, fixed="n",
             alternative="less", method="CP", power=0.8)
        
# One might accept to detect delta=0.004,
#   i.e. reject H0: p>=0.005 with power 80 percent 
#   when the true proportion is 0.001:
designPower(s=100, n=30, delta=0.004, p.hyp=0.005, fixed="n",
             alternative="less", method="CP", power=0.8)
designPower(s=100, n=30, delta=0.004, p.hyp=0.005, fixed="n",
             alternative="less", method="score", power=0.8)
}
\references{
\insertRef{Swallow1985}{binGroup2}
}
\seealso{
\code{\link{gtPower}} for calculation of power and bias depending 
on \kbd{n}, \kbd{s}, \kbd{delta}, \kbd{p.hyp}, \kbd{conf.level}, 
and \kbd{method}, and \code{\link{designEst}} to choose the group size 
\kbd{s} according to the minimal mse of the estimator, as given in 
Swallow (1985).

Other estimation functions: 
\code{\link{designEst}()},
\code{\link{gtPower}()},
\code{\link{gtTest}()},
\code{\link{gtWidth}()},
\code{\link{propCI}()},
\code{\link{propDiffCI}()}
}
\author{
The \code{nDesign} and \code{sDesign} functions were originally 
written by Frank Schaarschmidt for the \code{binGroup} package. Minor 
modifications were made for inclusion in the \code{binGroup2} package.
}
\concept{estimation functions}
