% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledBinomialFunctions.r
\name{propDiffCI}
\alias{propDiffCI}
\title{Confidence intervals for the difference of proportions
in group testing}
\usage{
propDiffCI(
  x1,
  m1,
  x2,
  m2,
  n1 = rep(1, length(x1)),
  n2 = rep(1, length(x2)),
  pt.method = c("Firth", "Gart", "bc-mle", "mle"),
  ci.method = c("skew-score", "bc-skew-score", "score", "lrt", "Wald"),
  conf.level = 0.95,
  tol = .Machine$double.eps^0.5
)
}
\arguments{
\item{x1}{vector specifying the observed number of positive
groups among the number of groups tested (\kbd{n1}) in population 1.}

\item{m1}{vector of corresponding group sizes in population 1.
Must have the same length as \kbd{x1}.}

\item{x2}{vector specifying the observed number of positive
groups among the number of groups tested (\kbd{n2}) in population 2.}

\item{m2}{vector of corresponding group sizes in population 2.
Must have the same length as \kbd{x2}.}

\item{n1}{vector of the corresponding number of groups with
sizes \kbd{m1}.}

\item{n2}{vector of the corresponding number of groups with
sizes \kbd{m2}.}

\item{pt.method}{character string specifying the point estimator to 
compute. Options include \kbd{"Firth"} for the bias-preventative estimator 
(Hepworth & Biggerstaff, 2017), the default \kbd{"Gart"} for the 
bias-corrected MLE (Biggerstaff, 2008), \kbd{"bc-mle"} (same as 
\kbd{"Gart"} for backward compatibility), and \kbd{"mle"} for the MLE.}

\item{ci.method}{character string specifying the confidence interval to 
compute. Options include \kbd{"skew-score"} for the skewness-corrected, 
\kbd{"score"} for the score (the default), \kbd{"bc-skew-score"} for the 
bias- and skewness-corrected, \kbd{"lrt"} for the likelihood ratio test, 
and \kbd{"Wald"} for the Wald interval. See Biggerstaff (2008) for
additional details.}

\item{conf.level}{confidence level of the interval.}

\item{tol}{the accuracy required for iterations in internal functions.}
}
\value{
A list containing:
\item{d}{the estimated difference of proportions.}
\item{lcl}{the lower confidence limit.}
\item{ucl}{the upper confidence limit.}
\item{pt.method}{the method used for point estimation.}
\item{ci.method}{the method used for confidence interval estimation.}
\item{conf.level}{the confidence level of the interval.}
\item{x1}{the numbers of positive groups in population 1.}
\item{m1}{the sizes of the groups in population 1.}
\item{n1}{the numbers of groups with corresponding group sizes
\kbd{m1} in population 1.}
\item{x2}{the numbers of positive groups in population 2.}
\item{m2}{the sizes of the groups in population 2.}
\item{n2}{the numbers of groups with corresponding group sizes
\kbd{m2} in population 2.}
}
\description{
Calculates confidence intervals for the difference of two 
proportions based on group testing data.
}
\details{
Confidence interval methods include the Wilson score 
(\kbd{ci.method="score"}), skewness-corrected score 
(\kbd{ci.method="skew-score"}), bias- and skewness-corrected score 
(\kbd{ci.method="bc-skew-score"}), likelihood ratio test 
(\kbd{ci.method="lrt"}), and Wald (\kbd{ci.method="Wald"}) interval. 
For computational details, simulation results, and recommendations on 
confidence interval methods, see Biggerstaff (2008).

Point estimates available include the MLE (\kbd{pt.method="mle"}), 
bias-corrected MLE (\kbd{pt.method="Gart"} or \kbd{pt.method="bc-mle"}), 
and bias-preventative (\kbd{pt.method="Firth"}). For additional details 
and recommendations on point estimation, see Hepworth and Biggerstaff 
(2017).
}
\examples{
# Estimate the prevalence in two populations 
#   with multiple groups of various sizes:
# Population 1:
#   0 out of 5 groups test positively with 
#   groups of size 1 (individual testing); 
#   0 out of 5 groups test positively with 
#   groups of size 5;
#   1 out of 5 groups test positively with 
#   groups of size 10; and
#   2 out of 5 groups test positively with 
#   groups of size 50.
# Population 2:
#   0 out of 5 groups test positively with
#   groups of size 1 (individual testing);
#   1 out of 5 groups test positively with 
#   groups of size 5;
#   0 out of 5 groups test positively with 
#   groups of size 10; and 
#   4 out of 5 groups test positively with 
#   groups of size 50.
x1 <- c(0,0,1,2)
m <- c(1,5,10,50)
n <- c(5,5,5,5)
x2 <- c(0,1,0,4)
propDiffCI(x1=x1, m1=m, x2=x2, m2=m, n1=n, n2=n, 
           pt.method="Gart", ci.method="score")

# Compare recommended methods:
propDiffCI(x1=x1, m1=m, x2=x2, m2=m, n1=n, n2=n,
           pt.method="mle", ci.method="lrt")

propDiffCI(x1=x1, m1=m, x2=x2, m2=m, n1=n, n2=n,
           pt.method="mle", ci.method="score")

propDiffCI(x1=x1, m1=m, x2=x2, m2=m, n1=n, n2=n,
           pt.method="mle", ci.method="skew-score")
}
\references{
\insertRef{Biggerstaff2008}{binGroup2}

\insertRef{Hepworth2017}{binGroup2}
}
\seealso{
\code{\link{propCI}} for confidence intervals for one proportion 
in group testing, \code{\link{gtTest}} for hypothesis tests in group 
testing, and \code{\link{gtPower}} for power calculations in group testing.

Other estimation functions: 
\code{\link{designEst}()},
\code{\link{designPower}()},
\code{\link{gtPower}()},
\code{\link{gtTest}()},
\code{\link{gtWidth}()},
\code{\link{propCI}()}
}
\author{
This function was originally written as the \code{pooledBinDiff} 
function by Brad Biggerstaff for the \code{binGroup} package. Minor 
modifications were made for inclusion of the function in the 
\code{binGroup2} package.
}
\concept{estimation functions}
