#' Rice QTL genotype data
#'
#' Data from "Three representative inter and intra-subspecific crosses
#'  reveal the genetic architecture of reproductive isolation in rice."
#'
#' @docType data
#'
#' @usage data(geno)
#'
#' @format An object of class \code{"cross"}; see \code{\link[qtl]{read.cross}}.
#'
#' @keywords datasets
#'
#' @references Li, G. et al. (2017) The Plant Journal 92, 349–362.
#' (\href{https://www.ncbi.nlm.nih.gov/pubmed/28805257}{PubMed})
#'
#' @examples
#' data(geno)
"geno"


#' Rice QTL phenotype data
#'
#' Data from "Three representative inter and intra-subspecific crosses
#'  reveal the genetic architecture of reproductive isolation in rice."
#'
#' @docType data
#'
#' @usage data(pheno)
#'
#' @format An object of class \code{"cross"}; see \code{\link[qtl]{read.cross}}.
#'
#' @keywords datasets
#'
#' @references Li, G. et al. (2017) The Plant Journal 92, 349–362.
#' (\href{https://www.ncbi.nlm.nih.gov/pubmed/28805257}{PubMed})
#'
#' @examples
#' data(pheno)
"pheno"

