% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexfunctions.r
\name{scagnostic.index}
\alias{scagnostic.index}
\alias{outlying}
\alias{skewed}
\alias{clumpy}
\alias{sparse}
\alias{striated}
\alias{convex}
\alias{skinny}
\alias{stringy}
\alias{monotonic}
\title{Find selected scagnostics index value for a scatterplot}
\usage{
scagnostic.index(x, y, name = "Outlying")

outlying(x, y)

skewed(x, y)

clumpy(x, y)

sparse(x, y)

striated(x, y)

convex(x, y)

skinny(x, y)

stringy(x, y)

monotonic(x, y)
}
\arguments{
\item{x, y}{1d vectors}

\item{name}{selected index from the list of available scagnostics}
}
\description{
Returns the selected scagnostics index for a provided set of
two 1d vectors, either by providing the name to the
scagnostics.index function, or calling the corresponding wrapper
function.
}
\details{
Available scagnostics are: 

\itemize{
  \item Outlying
  \item Skewed
  \item Clumpy
  \item Sparse
  \item Striated
  \item Convex
  \item Skinny
  \item Stringy
  \item Monotonic
}
}
\examples{
scagnostic.index(rnorm(100), rnorm(100), name = "Convex")
convex(rnorm(100), rnorm(100))
}
