% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scagnostics.r
\name{scagnostics}
\alias{scagnostics}
\alias{scagnostics.default}
\alias{scagnostics.matrix}
\alias{scagnostics.data.frame}
\alias{scagnostics_2d}
\title{Calculate scagnostics for a scatterplot}
\usage{
scagnostics(x, ...)

\method{scagnostics}{default}(x, y, bins = 50, outlierRmv = TRUE, ...)

\method{scagnostics}{matrix}(x, ...)

\method{scagnostics}{data.frame}(x, ...)

scagnostics_2d(x, ...)
}
\arguments{
\item{x, y}{object to calculate scagnostics on: a vector, a matrix or a data.frame}

\item{...}{Extra arguments}

\item{bins}{number of bins, default=50}

\item{outlierRmv}{logical for trimming data, default=TRUE}
}
\description{
Scagnostics summarize potentially interesting patterns in 2d scatterplot
}
\details{
Current scagnostics are: 

\itemize{
  \item Outlying
  \item Skewed
  \item Clumpy
  \item Sparse
  \item Striated
  \item Convex
  \item Skinny
  \item Stringy
  \item Monotonic
}

These are described in more detail in: 
Graph-Theoretic Scagnostics, Leland Wilkinson, Anushka 
Anand, Robert Grossman. 
\url{https://papers.rgrossman.com/proc-094.pdf}

You can call the function with two 1d vectors to get a single vector
of scagnostics, or with a 2d structure (matrix or data frame) to get 
scagnostics for every combination of the variables.
}
\examples{
scagnostics(1:10, 1:10)
scagnostics(rnorm(100), rnorm(100))
scagnostics(mtcars)
scagnostics(as.matrix(mtcars))
}
