% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpts.R
\name{as.data.frame.vpts}
\alias{as.data.frame.vpts}
\title{Convert a time series of vertical profiles (\code{vpts}) to a data frame}
\usage{
\method{as.data.frame}{vpts}(
  x,
  row.names = NULL,
  optional = FALSE,
  quantities = names(x$data),
  suntime = TRUE,
  geo = TRUE,
  elev = -0.268,
  lat = NULL,
  lon = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{vpts}.}

\item{row.names}{\code{NULL} or a character vector giving the row names for
the data frame. Missing values are not allowed.}

\item{optional}{If \code{FALSE} then the names of the variables in the data
frame are checked to ensure that they are syntactically valid variable names
and are not duplicated.}

\item{quantities}{An optional character vector with the names of the
quantities to include as columns in the data frame.}

\item{suntime}{Logical, when TRUE, adds sunrise/sunset and day/night
information to each row.}

\item{geo}{Logical, when TRUE, adds latitude, longitude and antenna height
of the radar to each row.}

\item{elev}{Sun elevation in degrees, see \link{sunrise}/\link{sunset}.}

\item{lat}{Radar latitude in decimal degrees. When set, overrides the
latitude stored in \code{x} in \link{sunrise}/\link{sunset} calculations.}

\item{lon}{Radar longitude in decimal degrees. When set, overrides the
longitude stored in \code{x} in \link{sunrise}/\link{sunset} calculations.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
An object of class data.frame.
}
\description{
Converts vertical profile time series (objects of class \code{vpts}) to a
data Frame, and optionally adds information on sunrise/sunset, day/night
and derived quantities like migration traffic rates.
}
\details{
Note that only the 'dens' quantity is thresholded for radial velocity
standard deviation by \link{sd_vvp_threshold}. Note that this is different from the
default \link{plot.vp}, \link{plot.vpts} and \link{get_quantity.vp}
functions, where quantities "eta", "dbz", "ff", "u", "v", "w", "dd" are all
thresholded by \link{sd_vvp_threshold}.
}
\examples{
# load an example vertical profile time series object
data(example_vpts)
example_vpts

# convert the object to a data.frame
df <- as.data.frame(example_vpts)

# do not compute sunrise/sunset information
df <- as.data.frame(example_vpts, suntime = FALSE)

# override the latitude/longitude information stored in the object
# when calculating sunrise / sunset
df <- as.data.frame(example_vpts, suntime = TRUE, lat = 50, lon = 4)

# print first then rows of data.frame to console:
df[1:10, ]
}
