% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexrad_odim.R
\name{nexrad_to_odim}
\alias{nexrad_to_odim}
\title{Convert a NEXRAD polar volume file to an ODIM polar volume file}
\usage{
nexrad_to_odim(
  pvolfile_nexrad,
  pvolfile_odim,
  verbose = FALSE,
  mount = dirname(pvolfile_nexrad),
  local_install
)
}
\arguments{
\item{pvolfile_nexrad}{Polar volume input file in RSL format.}

\item{pvolfile_odim}{Filename for the polar volume in ODIM HDF5 format to be
generated.}

\item{verbose}{Logical. When \code{TRUE}, Docker \code{stdout} is piped to the R
console. Always \code{TRUE} on Windows.}

\item{mount}{Character. Directory path of the mount point for the Docker
container.}

\item{local_install}{Character. Path to local vol2bird installation (e.g.
\code{your/vol2bird_install_directory/vol2bird/bin/vol2bird.sh}).}
}
\value{
\code{TRUE} on success
}
\description{
Convert a NEXRAD polar volume file to an ODIM polar volume file
}
\examples{
\dontrun{
# download a NEXRAD file, save as KBGM_example
download.file(paste("https://noaa-nexrad-level2.s3.amazonaws.com/",
  "2019/10/01/KBGM/KBGM20191001_000542_V06",
  sep = ""
), "~/KBGM_example")

# convert to ODIM format
nexrad_to_odim("~/KBGM_example", "~/KBGM_example.h5")

# verify that we have generated a polar volume in ODIM HDF5 format
get_odim_object_type("~/KBGM_example.h5")

# clean up
file.remove("~/KBGM_example", "~/KBGM_example.h5")
}
}
