% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_biotype_raster.R
\name{biotypeRaster}
\alias{biotypeRaster}
\title{Bioclimatic classification (raster mode)}
\usage{
biotypeRaster(
  temp = NULL,
  prec = NULL,
  CC = NULL,
  wout = NULL,
  ncpu = 1,
  PET = NULL,
  bh = NULL
)
}
\arguments{
\item{temp}{SpatRaster object with 12 layers representing temperature from January to December.}

\item{prec}{SpatRaster object with 12 layers representing precipitation from January to December.}

\item{CC}{Field capacity. It can be numeric (1 value) or a SpatRaster object.}

\item{wout}{Optional. Path and name of the output raster file.}

\item{ncpu}{number of cores to use in calculation. If not provided, sequential mode is used (1 core).}

\item{PET}{Potential evapotranspiration. Optional. It must be a SpatRaster object.}

\item{bh}{Water balance. Optional. It must be a SpatRaster object.}
}
\value{
SpatRaster with 3 variables ("TBR": Types of Bioclimatic Regime; "zonal": zonal units; "sub": bioclimatic regime subtypes).
}
\description{
Calculates bioclimatic classification based on bioclimatic balance.
}
\examples{
\donttest{
wb <- terra::rast(wbRast)
btr <- biotypeRaster(bh = wb)
}
}
