% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_watbal.R
\name{watbal}
\alias{watbal}
\title{Function to calculate water balance}
\usage{
watbal(t, p, lat, CC)
}
\arguments{
\item{t}{Monthly average temperature data (12 nueric values).}

\item{p}{Monthly average precipitation data (12 nueric values).}

\item{lat}{Latitude in degrees. For southern latitudes use negative values.}

\item{CC}{Field capacity. It depends on water retention capacity and depth of roots. Use 400 as default value.}
}
\value{
data frame with 12 variables: 'Tmp', 'Pcp', 'PET', 'P_PET', 'ppa', 'ST', 'i_ST', 'ETR', 'Dh', 'S', 'r', 'rP'.
}
\description{
Computes water balance from temperature and precipitation data.
}
\examples{
watbal(t = rnorm(12, 18, 6), p = rnorm(12, 50, 30),
       lat = 35, CC = 400)
}
