% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bioint_raster.R
\name{biointRaster}
\alias{biointRaster}
\title{Computation of Bioclimatic Intensities (raster mode)}
\usage{
biointRaster(bb, path = NULL)
}
\arguments{
\item{bb}{Bioclimatic balance in raster format.}

\item{path}{Optional. Path (folder) where the output raster files will be saved.}
}
\value{
SpatRaster with 120 layers corresponding to the 12 monthly values of "IBPc","IBCc","IBLc","IBRc","IBSc","IBPf","IBCf","IBLf","IBRf","IBSf".
}
\description{
Computes bioclimatic intensities from bioclimatic balance.
}
\examples{
\donttest{
bb <- terra::rast(bbRast)
bi <- biointRaster(bb, path=NULL)
}
}
