% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-top-level-fields.R
\name{compose_tlf_v1.3.0}
\alias{compose_tlf_v1.3.0}
\alias{compose_tlf}
\title{Compose BioCompute Object - Top Level Fields (v1.3.0)}
\usage{
compose_tlf_v1.3.0(
  provenance,
  usability,
  extension,
  description,
  execution,
  parametric,
  io,
  error,
  bco_id = NULL
)

compose_tlf(
  provenance,
  usability,
  extension,
  description,
  execution,
  parametric,
  io,
  error,
  bco_id = NULL
)
}
\arguments{
\item{provenance}{Provenance domain}

\item{usability}{Usability domain}

\item{extension}{Extension domain}

\item{description}{Description domain}

\item{execution}{Execution domain}

\item{parametric}{Parametric domain}

\item{io}{I/O domain}

\item{error}{Error domain}

\item{bco_id}{BioCompute Object identifier
(\href{https://github.com/biocompute-objects/BCO_Specification/blob/master/top-level.md#202-biocompute-object-identifier-bco_id}{definition}).
If \code{NULL}, will use a UUID generated by \code{\link{generate_id}}.}
}
\value{
A vector of top level fields
}
\description{
Compose BioCompute Object - Top Level Fields (v1.3.0)
}
\examples{
compose_tlf(
  compose_provenance(), compose_usability(), compose_extension(),
  compose_description(), compose_execution(), compose_parametric(),
  compose_io(), compose_error()
) \%>\% convert_json()
}
