% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-extension-fhir.R
\name{compose_fhir_v1.3.0}
\alias{compose_fhir_v1.3.0}
\alias{compose_fhir}
\title{Compose BioCompute Object - FHIR Extension (v1.3.0)}
\usage{
compose_fhir_v1.3.0(endpoint = NULL, version = NULL, resources = NULL)

compose_fhir(endpoint = NULL, version = NULL, resources = NULL)
}
\arguments{
\item{endpoint}{Character string. The URL of the endpoint of the
FHIR server containing the resource.}

\item{version}{Character string. The FHIR version used.}

\item{resources}{Data frame with two variables: \code{id} and \code{resource}.
Each row is one item of resources to fetch from the endpoint.}
}
\value{
A list of class \code{bco.domain}
}
\description{
Compose BioCompute Object - FHIR Extension (v1.3.0)
}
\examples{
fhir_endpoint <- "https://fhirtest.uhn.ca/baseDstu3"
fhir_version <- "3"
fhir_resources <- data.frame(
  "id" = c("21376", "6288583", "25544", "92440", "4588936"),
  "resource" = c(
    "Sequence", "DiagnosticReport", "ProcedureRequest",
    "Observation", "FamilyMemberHistory"
  ),
  stringsAsFactors = FALSE
)

compose_fhir(fhir_endpoint, fhir_version, fhir_resources) \%>\% convert_json()
}
